<?php 
/**
 * @version        2018年06月12日 小虎哥 <1105415366@qq.com> $
 * @copyright      Copyright (c) 2017 - 2050, DesDev, Inc.
 * @link           http://www.dede58.com 织梦58
 */
require_once(dirname(__FILE__)."/include/common.inc.php");
header('Cache-Control:private');
define('DS', DIRECTORY_SEPARATOR);
defined('ROOT_PATH') or define('ROOT_PATH', realpath(dirname($_SERVER['SCRIPT_FILENAME'])));
@session_start();
$cfg_soft_lang = !empty($cfg_soft_lang) ? $cfg_soft_lang : 'utf-8';  // 网站编码
// $datapathStr = trim($cfg_tplcache_dir, '/');
$datapathArr = explode('/', DEDEDATA);
$datapath = !empty($datapathArr[count($datapathArr) - 1]) ? $datapathArr[count($datapathArr) - 1] : 'data';
$datapath = '/'.$datapath;

$adminpath = !empty($adminpath) ? $adminpath : 'dede'; // 后台目录

$dede58 = new Dede58();

if(empty($dopost)) $dopost = '';
if(empty($step)) $step = 1;

if ('POST' == strtoupper($_SERVER['REQUEST_METHOD'])) {
    if (!file_exists(DEDEROOT.DS.$adminpath)) {
        $dede58->ShowMsg("后台目录{$adminpath}不存在！", "-1");
        exit;
    }
    $_SESSION['adminpath'] = $adminpath;
}

if ('ftp' == $opt) {
    $dede58->ShowMsg("请通过FTP或者其他方式备份整站点", "?opt=index", 0, 3000);
    exit;
} else if ('download' == $opt) {
    if ('POST' == strtoupper($_SERVER['REQUEST_METHOD'])) {
        $dede58->ShowMsg("正在下载中……请耐心等待", "?opt=download", 0, 100);
        exit;
    } else {
        $msg = $dede58->download();
        if (true === $msg) {
            $dede58->ShowMsg("下载成功，正在解压中……", "?opt=unzip", 0, 1000);
            exit;
        }
	}
}  else if ('unzip' == $opt) {
    $msg = $dede58->unzip();
    if (true === $msg) {
        $dede58->ShowMsg("解压成功", "?opt=index", 0, 3000);
        exit;
    }
} elseif ('backup' == $opt) {
    $msg = $dede58->backup();
    if (true === $msg) {
        $dede58->ShowMsg("备份成功", "?opt=index", 0, 3000);
        exit;
    }
} elseif ('update' == $opt) {
    $msg = $dede58->update();
    if (true === $msg) {
        $dede58->ShowMsg("升级成功，正在更新系统缓存", "?opt=sys_cache_up&dopost=ok", 0, 1000);
        exit;
    }
} else if ('sys_cache_up' == $opt) {

    //管理缓存、管理员频道缓存
    $cache1 = DEDEDATA.'/cache/inc_catalog_base.inc';
    if(!file_exists($cache1)) $dede58->UpDateCatCache();
    $cacheFile = DEDEDATA.'/cache/admincat_1.inc';
    if(file_exists($cacheFile)) require_once($cacheFile);

    if($dopost=="ok")
    {
        if(empty($uparc)) $uparc = 0;
        if($step == -1)
        {
            if($uparc == 0) sleep(1);
            $dede58->ShowMsg("成功更新所有缓存！", "?opt=index", 0, 3000);
            exit;
        }

        //更新栏目缓存
        else if($step == 1)
        {
            $dede58->UpDateCatCache();
            $dede58->ClearOptCache();
            $dede58->ShowMsg("成功更新栏目缓存，及后台栏目选项,准备更新枚举缓存...","?opt=sys_cache_up&dopost=ok&step=2&uparc=$uparc");
            exit();
        }

        //更新枚举缓存
        else if($step == 2)
        {
            include_once(DEDEINC."/enums.func.php");
            $dede58->WriteEnumsCache();
            //WriteAreaCache(); 已过期
            $dede58->ShowMsg("成功更新枚举缓存，准备更新调用缓存...", "?opt=sys_cache_up&dopost=ok&step=3&uparc=$uparc");
            exit();
        }

        //清理arclist调用缓存、过期会员访问历史、过期短信
        else if($step == 3)
        {
            echo '<meta http-equiv="Content-Type" content="text/html; charset='.$cfg_soft_lang.'">';
            $dsql->ExecuteNoneQuery("DELETE FROM `#@__arccache`");
            echo "\n成功更新arclist调用缓存，准备清理过期会员访问历史...<hr />";
            $oldtime = time() - (90 * 24 * 3600);
            $dsql->ExecuteNoneQuery("DELETE FROM `#@__member_vhistory` WHERE vtime<'$oldtime' ");
            echo "成功清理过期会员访问历史，准备清理过期短信...<hr />";
            $dsql->ExecuteNoneQuery("DELETE FROM `#@__member_pms` WHERE sendtime<'$oldtime' ");
            echo "成功清理过期短信，准备修正错误文档，这可能要占较长的时间...";
            if($uparc == 1)
            {
                echo "<script language='javascript'>location='?opt=sys_cache_up&dopost=ok&step=9';</script>";
            }
            else
            {
                echo "<script language='javascript'>location='?opt=sys_cache_up&dopost=ok&step=-1&uparc=$uparc';</script>";
            }
            exit();
        }
        //修正错误文档
        else if($step == 9)
        {
            $dede58->ShowMsg('修正错误文档操作已经取消，请在&lt;系统-&gt;系统错误修复[S]&gt;中操作...','?opt=sys_cache_up&dopost=ok&step=-1&uparc=1',0,5000);
            exit();
        }
    }
} elseif ('restore' == $opt) {
    $msg = $dede58->restore();
    if (true === $msg) {
        $dede58->ShowMsg("还原成功，正在更新系统缓存", "?opt=sys_cache_up&dopost=ok", 0, 1000);
        exit;
    }
} elseif ('move' == $opt) {
    $msg = $dede58->move();
    if (true === $msg) {
        $dede58->ShowMsg("移除无效文件成功", "?opt=index", 0, 3000);
        exit;
    }
} elseif ('move_restore' == $opt) {
    $msg = $dede58->move_restore();
    if (true === $msg) {
        $dede58->ShowMsg("还原无效文件成功", "?opt=index", 0, 3000);
        exit;
    }
} else {
    $dede58->getVersion();
}

class Dede58
{
    private $zipfilename; // 压缩包名
    private $folderName; // 解压缩文件夹名
    private $backupName; // 备份文件夹名
    private $source_dir; // 站点目录路径，支持子目录站点
    private $upgrade_dir; // 更新包路径
    private $adminpath; // 后台目录
    private $download_url; // 更新包远程下载

    /**
     * 析构函数
     */
    function  __construct() {
        global $cfg_cmspath, $adminpath, $cfg_soft_lang;
        $this->backupName = '20140606';
        if (stristr(strtolower($cfg_soft_lang), 'utf')) {
            $this->download_url = 'http://upgrade.dede58.com/dedecms/utf-8/dede58.com.zip';
        } else {
            $this->download_url = 'http://upgrade.dede58.com/dedecms/gb2312/dede58.com.zip';
        }
        $downFileName = explode('/', $this->download_url);
		$this->zipfilename = end($downFileName);
        $downFileName = end($downFileName);
        $this->folderName = str_replace(".zip", "", $this->zipfilename);  // 文件夹
        $this->source_dir = ROOT_PATH.$cfg_cmspath;
        $this->upgrade_dir = $this->source_dir.DS.$this->folderName;
        $this->adminpath = $adminpath;
    }

    /**
     * 安装目录删除文件
     */
    public function getInstallFileArr()
    {
        return array(
            'install',
        );
    }

    /**
     * 留言模块删除文件
     */
    public function getGuestbookFileArr()
    {
        return array(
            'plus/guestbook',
            'plus/guestbook.php',
        );
    }

    /**
     * 计划任务控制
     */
    public function getTaskFileArr()
    {
        return array(
            'plus/task',
            'plus/task.php',
        );
    }

    /**
     * 图书评论和评论调用文件
     */
    public function getBookfeedbackFileArr()
    {
        return array(
            'plus/bookfeedback.php',
            'plus/bookfeedback_js.php',
        );
    }

    /**
     * 分享到插件
     */
    public function getBshareFileArr()
    {
        return array(
            'plus/bshare.php',
        );
    }

    /**
     * 购物车
     */
    public function getCarFileArr()
    {
        return array(
            'plus/car.php',
            'plus/posttocar.php',
            'plus/carbuyaction.php',
        );
    }

    /**
     * 调用评论
     */
    public function getCommentsFileArr()
    {
        return array(
            'plus/comments_frame.php',
        );
    }

    /**
     * 顶踩
     */
    public function getDiggFileArr()
    {
        return array(
            'plus/digg_ajax.php',
            'plus/digg_frame.php',
        );
    }

    /**
     * 下载和次数统计
     */
    public function getDownloadFileArr()
    {
        return array(
            'plus/download.php',
            'plus/disdls.php',
        );
    }

    /**
     * 纠错
     */
    public function getErraddsaveFileArr()
    {
        return array(
            'plus/erraddsave.php',
            $this->adminpath.'/erraddsave.php',
        );
    }

    /**
     * 评论
     */
    public function getFeedbackFileArr()
    {
        return array(
            'plus/feedback.php',
            'plus/feedback_ajax.php',
            'plus/feedback_js.php',
            $this->adminpath.'/feedback_edit.php',
            $this->adminpath.'/feedback_main.php',
        );
    }

    /**
     * 收藏文章
     */
    public function getStowFileArr()
    {
        return array(
            'plus/stow.php',
        );
    }

    /**
     * 投票
     */
    public function getVoteFileArr()
    {
        return array(
            'plus/vote.php',
            $this->adminpath.'/vote_add.php',
            $this->adminpath.'/vote_edit.php',
            $this->adminpath.'/vote_getcode.php',
        );
    }

    /**
     * 高级搜索
     */
    public function getAdvancedsearchFileArr()
    {
        return array(
            'plus/advancedsearch.php',
            'plus/heightsearch.php',
        );
    }

    /**
     * 异步方式调用指定的tag列表
     */
    public function getArcmultiFileArr()
    {
        return array(
            'plus/arcmulti.php',
        );
    }

    /**
     * 友情链接
     */
    public function getFlinkFileArr()
    {
        return array(
            'plus/flink.php',
            'plus/flink_add.php',
        );
    }

    /**
     * 自由列表
     */
    public function getFreelistFileArr()
    {
        return array(
            'plus/freelist.php',
            $this->adminpath.'/freelist_add.php',
            $this->adminpath.'/freelist_edit.php',
            $this->adminpath.'/freelist_main.php',
        );
    }

    /**
     * 自定义标签js调用方式
     */
    public function getMytag_jsFileArr()
    {
        return array(
            'plus/mytag_js.php',
        );
    }

    /**
     * 生成二维码
     */
    public function getQrcodeFileArr()
    {
        return array(
            'plus/qrcode.php',
        );
    }

    /**
     * 信息推荐
     */
    public function getRecommendFileArr()
    {
        return array(
            'plus/recommend.php',
        );
    }

    /**
     * RSS列表页
     */
    public function getRssFileArr()
    {
        return array(
            'plus/rss.php',
        );
    }

    /**
     * 显示大图片
     */
    public function getShowphotoFileArr()
    {
        return array(
            'plus/showphoto.php',
        );
    }

    /**
     * 会员模块
     */
    public function getMemberFileArr()
    {
        return array(
            'member',
            $this->adminpath.'/file_class.php',
            $this->adminpath.'/file_manage_control.php',
            $this->adminpath.'/file_manage_main.php',
            $this->adminpath.'/file_manage_view.php',
            $this->adminpath.'/file_pic_view.php',
        );
    }

    /**
     * 专题生成目录
     */
    public function getSpecialFileArr()
    {
        return array(
            'special',
        );
    }

    /**
     * 后台目录 - 文件管理器
     */
    public function getTplFileArr()
    {
        return array(
            $this->adminpath.'/tpl.php',
        );
    }

    /**
     * 后台目录 - 软件下载类
     */
    public function getSoftFileArr()
    {
        return array(
            $this->adminpath.'/soft_add.php',
            $this->adminpath.'/soft_config.php',
            $this->adminpath.'/soft_edit.php',
        );
    }

    /**
     * 后台目录 - 商城系统
     */
    public function getShopsFileArr()
    {
        return array(
            $this->adminpath.'/shops_delivery.php',
            $this->adminpath.'/shops_operations.php',
            $this->adminpath.'/shops_operations_cart.php',
            $this->adminpath.'/shops_operations_userinfo.php',
        );
    }

    /**
     * 后台目录 - 邮件发送
     */
    public function getMailFileArr()
    {
        return array(
            $this->adminpath.'/mail_file_manage.php',
            $this->adminpath.'/mail_getfile.php',
            $this->adminpath.'/mail_send.php',
            $this->adminpath.'/mail_title.php',
            $this->adminpath.'/mail_title_send.php',
            $this->adminpath.'/mail_type.php',
        );
    }

    /**
     * 后台目录 - 视频控制文件
     */
    public function getMediaFileArr()
    {
        return array(
            $this->adminpath.'/media_add.php',
            $this->adminpath.'/media_edit.php',
            $this->adminpath.'/media_main.php',
        );
    }

    /**
     * 后台目录 - 小说功能
     */
    public function getStoryFileArr()
    {
        return array(
            $this->adminpath.'/story_add.php',
            $this->adminpath.'/story_add_action.php',
            $this->adminpath.'/story_add_content.php',
            $this->adminpath.'/story_add_content_action.php',
            $this->adminpath.'/story_add_photo.php',
            $this->adminpath.'/story_add_photo_action.php',
            $this->adminpath.'/story_books.php',
            $this->adminpath.'/story_catalog.php',
            $this->adminpath.'/story_content_edit.php',
            $this->adminpath.'/story_do.php',
            $this->adminpath.'/story_edit.php',
            $this->adminpath.'/story_edit_action.php',
            $this->adminpath.'/story_edit_content_action.php',
            $this->adminpath.'/story_edit_photo_action.php',
            $this->adminpath.'/story_feedback_edit.php',
            $this->adminpath.'/story_feedback_main.php',
            $this->adminpath.'/story_list_chapter.php',
            $this->adminpath.'/story_list_content.php',
            $this->adminpath.'/story_photo_edit.php',
        );
    }

    /**
     * 后台目录 - 点卡管理功能文件
     */
    public function getCardsFileArr()
    {
        return array(
            $this->adminpath.'/cards_make.php',
            $this->adminpath.'/cards_manage.php',
            $this->adminpath.'/cards_type.php',
        );
    }

    /**
     * 后台目录 - 圈子功能
     */
    public function getGroupFileArr()
    {
        return array(
            $this->adminpath.'/group_edit.php',
            $this->adminpath.'/group_guestbook.php',
            $this->adminpath.'/group_main.php',
            $this->adminpath.'/group_notice.php',
            $this->adminpath.'/group_store.php',
            $this->adminpath.'/group_threads.php',
            $this->adminpath.'/group_user.php',
        );
    }

    /**
     * 后台目录 - 模板管理
     */
    public function getTempletsFileArr()
    {
        return array(
            $this->adminpath.'/templets_main.php',
            $this->adminpath.'/templets_one.php',
            $this->adminpath.'/templets_one_add.php',
            $this->adminpath.'/templets_one_edit.php',
            $this->adminpath.'/templets_tagsource.php',
        );
    }

    /**
     * 一键下载
     */
    public function download()
    {
        $result = $this->downloadFile($this->download_url);
        if($result != 1) {
            $this->ShowMsg('下载更新包失败，请到【www.dede58.com】手动下载放在站点目录下！', "-1");
            exit;
        }

        return true;
    }

    /**
     * 一键解压
     */
    public function unzip()
    {
        global $cfg_cmspath, $datapath;
        if (!file_exists($this->source_dir.DS.$this->zipfilename)) {
            $this->ShowMsg('请先执行【一键下载包】或者FTP上传更新包 '.$this->zipfilename, "-1");
            exit;
        }
        clearstatcache(); // 清除文件夹权限缓存
        if(!is_writeable($this->source_dir.$datapath.'/admin/ver.txt')) {
            $this->ShowMsg('文件目录'.$cfg_cmspath.$datapath.' 不可写，不能更新!!!', "-1");
            exit;
        }      

        /*删除之前解压的文件夹*/
        if (file_exists($this->upgrade_dir)) {
            $this->delFile($this->upgrade_dir, true);
        }
        /*--end*/

        /*解压文件*/
        $zip = new \ZipArchive();//新建一个ZipArchive的对象
        if($zip->open($this->source_dir.DS.$this->zipfilename) != true) {
            $this->ShowMsg('压缩包文件读取失败', "-1");
            exit;
        }
        $zip->extractTo($this->upgrade_dir.DS);//假设解压缩到在当前路径下文件夹内
        $zip->close();//关闭处理的zip文件
        /*--end*/

        return true;
    }

    /**
     * 一键备份
     */
    public function backup()
    {
        global $cfg_cmspath, $datapath, $adminpath;
        if (!file_exists($this->upgrade_dir)) {
            $this->ShowMsg('请先执行【一键解压包】', "-1");
            exit;
        }
        $ver = $this->backupName;
        /*删除之前备份的文件夹*/
        if (file_exists($this->source_dir.$datapath.DS.$ver)) {
            $this->delFile($this->source_dir.$datapath.DS.$ver, true);
        }
        /*--end*/
        /*开始备份目录文件*/
        $filelist = $this->getDirFile($this->upgrade_dir);
        if (!empty($filelist) && is_array($filelist)) {
            foreach ($filelist as $key => $val) {
                $val = preg_replace('/^dede\//i', $adminpath.'/', $val);
                $source_file = $this->source_dir.DS.$val;
                if (file_exists($source_file)) {
                    $destination_file = $this->source_dir.$datapath.DS.$ver.DS.$val;
                    $this->tp_mkdir(dirname($destination_file));
                    copy($source_file, $destination_file);
                }
            }
        }
        /*--end*/

        return true;
    }

    /**
     * 一键升级
     */
    public function update()
    {
        global $cfg_cmspath, $datapath;
        $ver = $this->backupName;
        if (!file_exists($this->source_dir.$datapath.DS.$ver)) {
            $this->ShowMsg('请先执行【一键备份文件】', "-1");
            exit;
        }
        // 递归复制文件夹            
        $this->recurse_copy($this->upgrade_dir.DS, $this->source_dir.DS);
        
        return true;
    }

    /**
     * 一键还原
     */
    public function restore()
    {
        global $cfg_cmspath, $datapath;
        $ver = $this->backupName;
        if (!file_exists($this->source_dir.$datapath.DS.$ver)) {
            $this->ShowMsg('没有可还原的备份包', "-1");
            exit;
        }
        // 递归复制文件夹            
        $this->recurse_copy($this->source_dir.$datapath.DS.$ver.DS, $this->source_dir.DS);
        
        return true;
    }

    /**
     * 移除无效文件
     */
    public function move()
    {
        global $cfg_cmspath, $datapath, $install, $guestbook, $task, $bookfeedback, $bshare, $car, $comments, $digg, $download, $erraddsave, $feedback, $stow, $vote, $advancedsearch, $arcmulti, $flink, $freelist, $mytag_js, $qrcode, $recommend, $rss, $showphoto, $member, $special, $tpl, $soft, $shops, $mail, $media, $story, $cards, $group, $templets;
        $ver = $this->backupName;

        /*指定删除的文件*/
        $move_filelist = array();
        if ($install == 1) { // 安装目录删除文件
            $move_filelist = array_merge($move_filelist, $this->getInstallFileArr());
        }
        if ($guestbook == 1) { // 留言模块删除文件
            $move_filelist = array_merge($move_filelist, $this->getGuestbookFileArr());
        }
        if ($task == 1) { // 计划任务控制
            $move_filelist = array_merge($move_filelist, $this->getTaskFileArr());
        }
        if ($bookfeedback == 1) { // 图书评论和评论调用文件
            $move_filelist = array_merge($move_filelist, $this->getBookfeedbackFileArr());
        }
        if ($bshare == 1) { // 分享到插件
            $move_filelist = array_merge($move_filelist, $this->getBshareFileArr());
        }
        if ($car == 1) { // 购物车
            $move_filelist = array_merge($move_filelist, $this->getCarFileArr());
        }
        if ($comments == 1) { // 调用评论
            $move_filelist = array_merge($move_filelist, $this->getCommentsFileArr());
        }
        if ($digg == 1) { // 顶踩
            $move_filelist = array_merge($move_filelist, $this->getDiggFileArr());
        }
        if ($download == 1) { // 下载和次数统计
            $move_filelist = array_merge($move_filelist, $this->getDownloadFileArr());
        }
        if ($erraddsave == 1) { // 纠错
            $move_filelist = array_merge($move_filelist, $this->getErraddsaveFileArr());
        }
        if ($feedback == 1) { // 评论
            $move_filelist = array_merge($move_filelist, $this->getFeedbackFileArr());
        }
        if ($stow == 1) { // 收藏文章
            $move_filelist = array_merge($move_filelist, $this->getStowFileArr());
        }
        if ($vote == 1) { // 投票
            $move_filelist = array_merge($move_filelist, $this->getVoteFileArr());
        }
        if ($advancedsearch == 1) { // 高级搜索
            $move_filelist = array_merge($move_filelist, $this->getAdvancedsearchFileArr());
        }
        if ($arcmulti == 1) { // 异步方式调用指定的tag列表
            $move_filelist = array_merge($move_filelist, $this->getArcmultiFileArr());
        }
        if ($flink == 1) { // 友情链接
            $move_filelist = array_merge($move_filelist, $this->getFlinkFileArr());
        }
        if ($freelist == 1) { // 自由列表
            $move_filelist = array_merge($move_filelist, $this->getFreelistFileArr());
        }
        if ($mytag_js == 1) { // 自定义标签js调用方式
            $move_filelist = array_merge($move_filelist, $this->getMytag_jsFileArr());
        }
        if ($qrcode == 1) { // 生成二维码
            $move_filelist = array_merge($move_filelist, $this->getQrcodeFileArr());
        }
        if ($recommend == 1) { // 信息推荐
            $move_filelist = array_merge($move_filelist, $this->getRecommendFileArr());
        }
        if ($rss == 1) { // RSS列表页
            $move_filelist = array_merge($move_filelist, $this->getRssFileArr());
        }
        if ($showphoto == 1) { // 显示大图片
            $move_filelist = array_merge($move_filelist, $this->getShowphotoFileArr());
        }
        if ($member == 1) { // 会员模块
            $move_filelist = array_merge($move_filelist, $this->getMemberFileArr());
        }
        if ($special == 1) { // 专题生成目录
            $move_filelist = array_merge($move_filelist, $this->getSpecialFileArr());
        }
        if ($tpl == 1) { // 后台目录 - 文件管理器
            $move_filelist = array_merge($move_filelist, $this->getTplFileArr());
        }
        if ($soft == 1) { // 后台目录 - 软件下载类
            $move_filelist = array_merge($move_filelist, $this->getSoftFileArr());
        }
        if ($shops == 1) { // 后台目录 - 商城系统
            $move_filelist = array_merge($move_filelist, $this->getShopsFileArr());
        }
        if ($mail == 1) { // 后台目录 - 邮件发送
            $move_filelist = array_merge($move_filelist, $this->getMailFileArr());
        }
        if ($media == 1) { // 后台目录 - 视频控制文件
            $move_filelist = array_merge($move_filelist, $this->getMediaFileArr());
        }
        if ($story == 1) { // 后台目录 - 小说功能
            $move_filelist = array_merge($move_filelist, $this->getStoryFileArr());
        }
        if ($cards == 1) { // 后台目录 - 点卡管理功能文件
            $move_filelist = array_merge($move_filelist, $this->getCardsFileArr());
        }
        if ($group == 1) { // 后台目录 - 圈子功能
            $move_filelist = array_merge($move_filelist, $this->getGroupFileArr());
        }
        if ($templets == 1) { // 后台目录 - 模板管理
            $move_filelist = array_merge($move_filelist, $this->getTempletsFileArr());
        }
        /*--end*/
        /*删除之前备份的无效文件*/
        // if (file_exists($this->source_dir.$datapath.DS.$ver.'_move')) {
        //     $this->delFile($this->source_dir.$datapath.DS.$ver.'_move', true);
        // }
        /*--end*/
        /*移除之前备份无效文件*/
        foreach ($move_filelist as $key => $val) {
            $source_file = $this->source_dir.DS.$val;
            $destination_file = $this->source_dir.$datapath.DS.$ver.'_move'.DS.$val;
            $this->tp_mkdir(dirname($destination_file));

            if (is_file($source_file) && file_exists($source_file)) {
                copy($source_file, $destination_file);
            } elseif (is_dir($source_file) && file_exists($source_file)) {
                // 递归复制文件夹            
                $this->recurse_copy($source_file, $destination_file);
            }
        }
        /*--end*/

        /*移除无效文件*/
        foreach ($move_filelist as $key => $val) {
            $source_file = $this->source_dir.DS.$val;
            if (is_file($source_file) && file_exists($source_file)) {
                @unlink($source_file);
            } elseif (is_dir($source_file) && file_exists($source_file)) {
                $this->delFile($source_file, true);
            }
        }
        /*--end*/
        
        return true;
    }

    /**
     * 还原无效文件
     */
    public function move_restore()
    {
        global $cfg_cmspath, $datapath;
        $ver = $this->backupName;
        if (!file_exists($this->source_dir.$datapath.DS.$ver.'_move')) {
            $this->ShowMsg('没有可还原的无效文件包', "-1");
            exit;
        }
        // 递归复制文件夹            
        $this->recurse_copy($this->source_dir.$datapath.DS.$ver.'_move'.DS, $this->source_dir.DS);
        
        return true;
    }

    // 递归删除文件夹
    public function delFile($path, $delDir = FALSE) {
        if(!is_dir($path)) {
            return FALSE; 
        }
        $handle = @opendir($path);
        if ($handle) {
            while (false !== ( $item = readdir($handle) )) {
                if ($item != "." && $item != "..") {
                    is_dir("$path/$item") ? $this->delFile("$path/$item", $delDir) : unlink("$path/$item");
                }
            }
            closedir($handle);
            if ($delDir) {
                return rmdir($path);
            }
        }else {
            if (file_exists($path)) {
                return unlink($path);
            } else {
                return FALSE;
            }
        }
    }
 
    /**     
     * @param type $fileUrl 下载文件地址
     * @param type $md5File 文件MD5 加密值 用于对比下载是否完整
     * @return string 错误或成功提示
     */
    public function downloadFile($fileUrl = '')
    {                    
        $downFileName = explode('/', $fileUrl);    
        $downFileName = end($downFileName);
        $saveDir = $this->source_dir.DS.$downFileName; // 保存目录
        $this->tp_mkdir(dirname($saveDir));
        if(!file_get_contents($fileUrl, 0, null, 0, 1)){
            $this->ShowMsg('下载升级文件不存在', "-1");
            exit;
        }
        $ch = curl_init($fileUrl);            
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_BINARYTRANSFER,1);
        $file = curl_exec ($ch);
        curl_close ($ch);                                                            
        $fp = fopen($saveDir,'w');
        fwrite($fp, $file);
        fclose($fp);

        return 1;
    }    

    /**
     * 删除指定文件列表
     */
    public function delDirFile($filelist = array(), $del_filelist = array())
    {
        foreach ($del_filelist as $key => $file) {
            $filename = $cfg_cmspath.DS.$file;
            if (file_exists($filename)) {
                @unlink($filename);
            }
        }
    }

    /**
     * 递归读取文件夹文件
     */
    public function getDirFile($directory, $dir_name='', &$arr_file = array()) {
        if (!file_exists($directory) ) {
            return false;
        }

        $mydir = dir($directory);
        while($file = $mydir->read())
        {
            if((is_dir("$directory/$file")) AND ($file != ".") AND ($file != ".."))
            {
                if ($dir_name) {
                    $this->getDirFile("$directory/$file", "$dir_name/$file", $arr_file);
                } else {
                    $this->getDirFile("$directory/$file", "$file", $arr_file);
                }
                
            }
            else if(($file != ".") AND ($file != ".."))
            {
                if ($dir_name) {
                    $arr_file[] = "$dir_name/$file";
                } else {
                    $arr_file[] = "$file";
                }
            }
        }
        $mydir->close();

        return $arr_file;
    }

    /**
     * 获取当前CMS版本号
     */
    public function getVersion()
    {
        global $cfg_cmspath, $datapath;
        $minver = 20140606;
        $ver = 0;
        $version_txt_path = DEDEDATA.'/admin/ver.txt';
        if(file_exists($version_txt_path)) {
            $fp = fopen($version_txt_path, 'r');
            $content = fread($fp, filesize($version_txt_path));
            fclose($fp);
            $ver = $content ? $content : $ver;
        } else {
            $this->ShowMsg('缺少版本文件 '.DEDEDATA.'/admin/ver.txt', "-1");
            exit;
        }

        if (intval($ver) < intval($minver)) {
            die('当前版本太低，该工具只支持版本在 '.$minver.' 之上');
        }

        return $ver;
    }

     /**
      * 自定义函数递归的复制带有多级子目录的目录
      * 递归复制文件夹
      * @param type $src 原目录
      * @param type $dst 复制到的目录
      */                        
    //参数说明：            
    //自定义函数递归的复制带有多级子目录的目录
    public function recurse_copy($src, $dst)
    {
        $now = time();
        $dir = opendir($src);
        @mkdir($dst);
        while (false !== $file = readdir($dir)) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    $this->recurse_copy($src . '/' . $file, $dst . '/' . $file);
                }
                else {
                    if (file_exists($dst . DIRECTORY_SEPARATOR . $file)) {
                        if (!is_writeable($dst . DIRECTORY_SEPARATOR . $file)) {
                            $this->ShowMsg($dst . DIRECTORY_SEPARATOR . $file . '不可写', "-1");
                            exit;
                        }
                        @unlink($dst . DIRECTORY_SEPARATOR . $file);
                    }
                    if (file_exists($dst . DIRECTORY_SEPARATOR . $file)) {
                        @unlink($dst . DIRECTORY_SEPARATOR . $file);
                    }
                    $copyrt = copy($src . DIRECTORY_SEPARATOR . $file, $dst . DIRECTORY_SEPARATOR . $file);
                    if (!$copyrt) {
                        $this->ShowMsg('copy ' . $dst . DIRECTORY_SEPARATOR . $file . ' failed<br>', "-1");
                        exit;
                    }
                }
            }
        }
        closedir($dir);
    }

    /**
     * 递归创建目录 
     */  
    public function tp_mkdir($path, $purview = 0777)
    {
        if (!is_dir($path)) {
            $this->tp_mkdir(dirname($path), $purview);
            if (!mkdir($path, $purview)) {
                return false;
            }
        }
        return true;
    }

    /**
     *  短消息函数,可以在某个动作处理后友好的提示信息
     *
     * @param     string  $msg      消息提示信息
     * @param     string  $gourl    跳转地址
     * @param     int     $onlymsg  仅显示信息
     * @param     int     $limittime  限制时间
     * @return    void
     */
    public function ShowMsg($msg, $gourl, $onlymsg=0, $limittime=0)
    {
        global $cfg_soft_lang;
        if(empty($GLOBALS['cfg_plus_dir'])) $GLOBALS['cfg_plus_dir'] = '..';

        $htmlhead  = "<html>\r\n<head>\r\n<title>DedeCMS提示信息</title>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=".$cfg_soft_lang."\" />\r\n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no\">\r\n<meta name=\"renderer\" content=\"webkit\">\r\n<meta http-equiv=\"Cache-Control\" content=\"no-siteapp\" />";
        $htmlhead .= "<base target='_self'/>\r\n<style>div{line-height:160%;}</style></head>\r\n<body leftmargin='0' topmargin='0' bgcolor='#FFFFFF'>".(isset($GLOBALS['ucsynlogin']) ? $GLOBALS['ucsynlogin'] : '')."\r\n<center>\r\n<script>\r\n";
        $htmlfoot  = "</script>\r\n</center>\r\n</body>\r\n</html>\r\n";

        $litime = ($limittime==0 ? 1000 : $limittime);
        $func = '';

        if($gourl=='-1')
        {
            if($limittime==0) $litime = 5000;
            $gourl = "javascript:history.go(-1);";
        }

        if($gourl=='' || $onlymsg==1)
        {
            $msg = "<script>alert(\"".str_replace("\"","“",$msg)."\");</script>";
        }
        else
        {
            //当网址为:close::objname 时, 关闭父框架的id=objname元素
            if(preg_match('/close::/',$gourl))
            {
                $tgobj = trim(preg_replace('/close::/', '', $gourl));
                $gourl = 'javascript:;';
                $func .= "window.parent.document.getElementById('{$tgobj}').style.display='none';\r\n";
            }

            $func .= "      var pgo=0;
          function JumpUrl(){
            if(pgo==0){ location='$gourl'; pgo=1; }
          }\r\n";
            $rmsg = $func;
            $rmsg .= "document.write(\"<br /><div style='width:450px;padding:0px;border:1px solid #DADADA;'>";
            $rmsg .= "<div style='padding:6px;font-size:12px;border-bottom:1px solid #DADADA;background:#DBEEBD url({$GLOBALS['cfg_plus_dir']}/img/wbg.gif)';'><b>DedeCMS 提示信息！</b></div>\");\r\n";
            $rmsg .= "document.write(\"<div style='height:130px;font-size:10pt;background:#ffffff'><br />\");\r\n";
            $rmsg .= "document.write(\"".str_replace("\"","“",$msg)."\");\r\n";
            $rmsg .= "document.write(\"";

            if($onlymsg==0)
            {
                if( $gourl != 'javascript:;' && $gourl != '')
                {
                    $rmsg .= "<br /><a href='{$gourl}'>如果你的浏览器没反应，请点击这里...</a>";
                    $rmsg .= "<br/></div>\");\r\n";
                    $rmsg .= "setTimeout('JumpUrl()',$litime);";
                }
                else
                {
                    $rmsg .= "<br/></div>\");\r\n";
                }
            }
            else
            {
                $rmsg .= "<br/><br/></div>\");\r\n";
            }
            $msg  = $htmlhead.$rmsg.$htmlfoot;
        }
        echo $msg;
    }

    /**
     *  更新栏目缓存
     *
     * @access    public
     * @return    void
     */
    public function UpDateCatCache()
    {
        global $dsql, $cfg_multi_site, $cache1, $cacheFile;
        $cache2 = DEDEDATA.'/cache/channelsonlist.inc';
        $cache3 = DEDEDATA.'/cache/channeltoplist.inc';
        $dsql->SetQuery("SELECT id,reid,channeltype,issend,typename FROM `#@__arctype`");
        $dsql->Execute();
        $fp1 = fopen($cache1,'w');
        $phph = '?';
        $fp1Header = "<{$phph}php\r\nglobal \$cfg_Cs;\r\n\$cfg_Cs=array();\r\n";
        fwrite($fp1,$fp1Header);
        while($row=$dsql->GetObject())
        {
            // 将typename缓存起来
            $row->typename = base64_encode($row->typename);
            fwrite($fp1,"\$cfg_Cs[{$row->id}]=array({$row->reid},{$row->channeltype},{$row->issend},'{$row->typename}');\r\n");
        }
        fwrite($fp1, "{$phph}>");
        fclose($fp1);
        @unlink($cache2);
        @unlink($cache3);
    }

    // 清空选项缓存
    public function ClearOptCache()
    {
        $tplCache = DEDEDATA.'/tplcache/';
        $fileArray = glob($tplCache."inc_option_*.inc");
        if (count($fileArray) > 1)
        {
            foreach ($fileArray as $key => $value)
            {
                if (file_exists($value)) unlink($value);
                else continue;
            }
            return TRUE;
        }
        return FALSE;
    }

    /**
     *  更新枚举缓存
     *
     * @access    public
     * @param     string  $egroup  联动组
     * @return    string
     */
    public function WriteEnumsCache($egroup='')
    {
        global $dsql;
        $egroups = array();
        if($egroup=='') {
            $dsql->SetQuery("SELECT egroup FROM `#@__sys_enum` GROUP BY egroup ");
        }
        else {
            $dsql->SetQuery("SELECT egroup FROM `#@__sys_enum` WHERE egroup='$egroup' GROUP BY egroup ");
        }
        $dsql->Execute('enum');
        while($nrow = $dsql->GetArray('enum')) {
            $egroups[] = $nrow['egroup'];
        }
        foreach($egroups as $egroup)
        {
            $cachefile = DEDEDATA.'/enums/'.$egroup.'.php';
            $fp = fopen($cachefile,'w');
            fwrite($fp,'<'."?php\r\nglobal \$em_{$egroup}s;\r\n\$em_{$egroup}s = array();\r\n");
            $dsql->SetQuery("SELECT ename,evalue,issign FROM `#@__sys_enum` WHERE egroup='$egroup' ORDER BY disorder ASC, evalue ASC ");
            $dsql->Execute('enum');
            $issign = -1;
            $tenum = false; //三级联动标识
            while($nrow = $dsql->GetArray('enum'))
            {
                fwrite($fp,"\$em_{$egroup}s['{$nrow['evalue']}'] = '{$nrow['ename']}';\r\n");
                if($issign==-1) $issign = $nrow['issign'];
                if($nrow['issign']==2) $tenum = true;
            }
            if ($tenum) $dsql->ExecuteNoneQuery("UPDATE `#@__stepselect` SET `issign`=2 WHERE egroup='$egroup'; ");
            fwrite($fp,'?'.'>');
            fclose($fp);
            if(empty($issign)) $this->WriteEnumsJs($egroup);
        }
        return '成功更新所有枚举缓存！';
    }

    /**
     *  写入联动JS代码
     *
     * @access    public
     * @param     string    $egroup   联动组
     * @return    string
     */
    public function WriteEnumsJs($egroup)
    {
        $jsfile = DEDEDATA.'/enums/'.$egroup.'.js';
        $fp = fopen($jsfile, 'w');
        fwrite($fp, $this->GetEnumsJs($egroup));
        fclose($fp);
    }

    /**
     *  获取数据的JS代码(二级联动)
     *
     * @access    public
     * @param     string    $egroup   联动组
     * @return    string
     */
    public function GetEnumsJs($egroup)
    {
        global ${'em_'.$egroup.'s'};
        include_once(DEDEDATA.'/enums/'.$egroup.'.php');
        $jsCode = "<!--\r\n";
        $jsCode .= "em_{$egroup}s=new Array();\r\n";
        foreach(${'em_'.$egroup.'s'} as $k => $v)
        {
            // JS中将3级类目存放到第二个key中去
            if (preg_match("#([0-9]{1,})\.([0-9]{1,})#", $k, $matchs))
            {
                $valKey = $matchs[1] + $matchs[2] / 1000;
                $jsCode .= "em_{$egroup}s[{$valKey}]='$v';\r\n";
            } else { 
                $jsCode .= "em_{$egroup}s[$k]='$v';\r\n";
            }
        }
        $jsCode .= "-->";
        return $jsCode;
    }
}

?>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=<?php echo $cfg_soft_lang;?>" />
    <title>织梦CMS一键升级工具</title>
    <script src="http://code.jquery.com/jquery-2.1.1.min.js"></script>
	<style>ol li{ line-height:26px;font-size:14px;}</style>
</head>
<body>
<h1>织梦一键安全补丁工具箱V1.0</h1>
<p>注意：</p>
<ol>
    <li>只适用于织梦CMS开发的网站；</li>
    <li>更新日期以20140606起，直到官方最新20180109为止；</li>
    <li><b style="color:#ff0000">在更新之前先通过FTP备份网站到本地；</b></li>
    <li>此次更新只针对后台源码与部分php文件，不涉及后台配置文件、前台模板文件和数据库等，请放心；</li>
</ol>
<p>涉及文件：</p>
<ol>
    <li>织梦后台php文件；</li>
    <li>会员中心php文件；</li>
    <li>手机端php文件；</li>
    <li>plus目录下php文件；</li>
    <li>include目录下php文件；</li>
    <li>data目录下版本文件；</li>
</ol>
<p>功能介绍：</p>
<ol>
    <li>一键下载升级包：系统从远程服务器下载更新包到站点根目录；</li>
    <li>一键备份文件：自动备份更新之前要覆盖的文件；</li>
    <li>一键升级文件：将更新包一键覆盖到网站根目录下；</li>
    <li>移除无效文件：程序自动检测哪些无效文件并移除，以免给网站安全带来注木马的可能性；</li>
    <li>还原移除文件：移除之后导致网站功能问题，可以通过该按钮进行还原；</li>
    <li>一键还原全部更新文件：在网站出现代码错误不兼容的情况下，可以通过一键还原为更新之前的版本；</li>
</ol>
<br/>
<form id="form1" method="post" action="upgrade.php">
    <input type="hidden" name="opt" id="opt" value="" />
    <input type="button" name="download" id="download" data-opt="download" value="一键下载升级包" />
    后台目录名：
    <input type="text" name="adminpath" id="adminpath" value="<?php echo !empty($_SESSION['adminpath']) ? $_SESSION['adminpath'] : $adminpath;?>" />
    <input type="button" name="backup" id="backup" data-opt="backup" value="一键备份文件" />
    <input type="button" name="update" id="update" data-opt="update" value="一键升级文件" />
    <hr/>
    <br/>
    <p>以下是部分网站用不到的无效文件，为了提高安全性，建议勾选，并点击下方的【移除无效文件】按钮</p>
    <ul>
        <li><label><input type="checkbox" name="install" value="1" checked="true" />install【安装目录】</label></li>
        <li><label><input type="checkbox" name="erraddsave" value="1" checked="true" />plus与后台目录下erraddsave.php文件【纠错功能】</label></li>
        <li><label><input type="checkbox" name="feedback" value="1" checked="true" />plus与后台目录下以feedback_*.php开头的系列文件【评论功能】</label></li>
        <li><label><input type="checkbox" name="vote" value="1" checked="true" />plus与后台目录下以vote_*.php开头的系列文件【投票】</label></li>
        <li><label><input type="checkbox" name="freelist" value="1" checked="true" />plus与后台目录下以freelist_*.php开头的系列文件【自由列表】</label></li>
        <li><label><input type="checkbox" name="member" value="1" checked="true" />member目录，后台目录下以file_*.php开头的系列文件【会员中心，一般企业站不需要】</label></li>
        <li><label><input type="checkbox" name="special" value="1" checked="true" />special【专题生成目录，一般企业站模板用不上】（建议整个删除） </label></li>
        <li><label><input type="checkbox" name="shops" value="1" checked="true" />后台目录下以shops_*.php开头的系列文件【商城系统，极少用到】</label></li>
        <li>
            <label><input type="checkbox" id="plusall" checked="true" onclick="checkboxall(this, 'ul_plus');"/>plus目录（建议部分删除）</label>
            <ul id='ul_plus'>
                <li><label><input type="checkbox" name="guestbook" value="1" checked="true" data-pre="plus" />guestbook文件夹和guestbook.php【留言板，文件夹和文件】</label></li>
                <li><label><input type="checkbox" name="task" value="1" checked="true" data-pre="plus" />task文件夹和task.php【计划任务控制，文件夹和文件】</label></li>
                <li><label><input type="checkbox" name="bookfeedback" value="1" checked="true" data-pre="plus" />以bookfeedback_*.php开头的系列文件【图书评论和评论调用文件，存在注入漏洞，不安全】</label></li>
                <li><label><input type="checkbox" name="bshare" value="1" checked="true" data-pre="plus" />bshare.php【分享到插件】</label></li>
                <li><label><input type="checkbox" name="car" value="1" checked="true" data-pre="plus" />car.php、posttocar.php和carbuyaction.php【购物车】</label></li>
                <li><label><input type="checkbox" name="comments" value="1" checked="true" data-pre="plus" />comments_frame.php【调用评论，存在安全漏洞】</label></li>
                <li><label><input type="checkbox" name="digg" value="1" checked="true" data-pre="plus" />以digg_*.php开头的系列文件【顶踩】</label></li>
                <li><label><input type="checkbox" name="download" value="1" checked="true" data-pre="plus" />download.php和disdls.php【下载和次数统计】</label></li>
                <li><label><input type="checkbox" name="stow" value="1" checked="true" data-pre="plus" />stow.php【收藏文章】</label></li>
                <li><label><input type="checkbox" name="advancedsearch" value="1" checked="true" data-pre="plus" />advancedsearch.php ，heightsearch.php 【高级搜索】</label></li>
                <li><label><input type="checkbox" name="arcmulti" value="1" checked="true" data-pre="plus" />arcmulti.php 【异步方式调用指定的tag列表】</label></li>
                <li><label><input type="checkbox" name="flink" value="1" checked="true" data-pre="plus" />以flink_*.php开头的系列文件【友情链接、友情链接添加，会暴露模板路径】</label></li>
                <li><label><input type="checkbox" name="mytag_js" value="1" checked="true" data-pre="plus" />mytag_js.php 【自定义标签js调用方式，如果没用到后台的自定义宏标记，请删除】</label></li>
                <li><label><input type="checkbox" name="qrcode" value="1" checked="true" data-pre="plus" />qrcode.php 【生成二维码】</label></li>
                <li><label><input type="checkbox" name="recommend" value="1" checked="true" data-pre="plus" />recommend.php 【信息推荐】</label></li>
                <li><label><input type="checkbox" name="rss" value="1" checked="true" data-pre="plus" />rss.php 【RSS列表页】</label></li>
                <li><label><input type="checkbox" name="showphoto" value="1" checked="true" data-pre="plus" />showphoto.php 【显示大图片，如果没用到图集模型，请删除】</label></li>
            </ul>
        </li>
        <li>
            <label><input type="checkbox" id="dedeall" value="1" onclick="checkboxall(this, 'ul_dede');"/>dede【后台目录，有些用户的后台已经改成别的名字了，有些用不上的文件建议删除，以防注入】</label>
            <ul id="ul_dede">
                <li><label><input type="checkbox" name="tpl" value="1" checked="true" data-pre="dede" />tpl.php【文件管理器，安全隐患很大】</label></li>
                <li><label><input type="checkbox" name="soft" value="1" checked="true" data-pre="dede" />以soft_*.php开头的系列文件【软件下载类，存在安全隐患】</label></li>
                <li><label><input type="checkbox" name="mail" value="1" checked="true" data-pre="dede" />以mail_*.php开头的系列文件【邮件发送】</label></li>
                <li><label><input type="checkbox" name="media" value="1" checked="true" data-pre="dede" />media_add.php、media_edit.php、media_main.php【视频控制文件】</label></li>
                <li><label><input type="checkbox" name="story" value="1" checked="true" data-pre="dede" />以story_*.php开头的系列文件【小说功能】</label></li>
                <li><label><input type="checkbox" name="cards" value="1" checked="true" data-pre="dede" />以cards_*.php开头的系列文件【点卡管理功能文件】</label></li>
                <li><label><input type="checkbox" name="group" value="1" checked="true" data-pre="dede" />以group_*.php开头的系列php文件【圈子功能】</label></li>
                <li style="color:red;"><label><input type="checkbox" name="templets" value="1" data-pre="dede" />以templets_*.php开头的系列文件【模板管理，建议勾选删除，选用ftp管理】</label></li>
            </ul>
        </li>
    </ul>
    <input type="button" name="move" id="move" data-opt="move" value="移除无效文件" />
    <hr/>
    <br/>
    <input type="button" name="restore" id="restore" data-opt="restore" value="一键还原全部升级文件" />
	<input type="button" name="move_restore" id="move_restore" data-opt="move_restore" value="还原移除的全部文件" />
</form>

<script type="text/javascript">
    $(function(){
        $('input[type=button]').click(function(){
            var opt = $(this).attr('data-opt');
            $('input[name=opt]').val(opt);
            if (opt == 'ftp') {
                alert('请通过FTP或者其他方式备份整站点');
                return false;
            } else if (opt == 'move') {
                var checkboxlen = $('input[type=checkbox]:checked').length;
                if (checkboxlen < 1) {
                    alert('请勾选要移除的文件版块');
                    return false;
                }
            }
            if (confirm("确定要执行吗？")) {
                $('#form1').submit();
            } else {
                return false;
            }
        });


        var objlist = $('#ul_dede,#ul_plus');
        objlist.find('input[type=checkbox]').click(function(){
            var pre = $(this).attr('data-pre');
            var len = parseInt($('#ul_'+pre).find('input[type=checkbox]').length);
            var checkedlen = parseInt($('#ul_'+pre).find('input[type=checkbox]:checked').length);
            if (len > checkedlen) {
                $('#'+pre+'all').prop('checked', false);
            } else {
                $('#'+pre+'all').prop('checked', true);
            }
        });
    });

    function checkboxall(obj, id)
    {
        $('#'+id).find('input[type=checkbox]').prop('checked',obj.checked);
    }
</script>
</body>
</html>